package com.ejie.aa94a.utils;

import java.io.IOException;
import java.util.List;
import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa94a.constantes.Constantes;
import com.ejie.aa94a.constantes.ConstantesPDF;
import com.ejie.aa94a.model.calculo.Bobina;
import com.ejie.aa94a.model.calculo.Estiba;
import com.ejie.aa94a.model.calculo.Resultado;
import com.ejie.aa94a.model.calculo.Transporte;
import com.ejie.aa94a.model.config.TipoDistancia;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

/**
 * 
 * @author GFI
 * 
 */
public class ResultadoPDF {

	/**
	 * Constructor de ResultadoPDF
	 */
	private ResultadoPDF() {
	}

	/**
	 * 
	 * Pintamos la primera pag a modo de presentacion
	 * 
	 * 
	 * @param writerResolucion
	 * @param documentResolucion
	 * @param tipoResolucion
	 * @throws DocumentException
	 *             e
	 * @throws IOException
	 *             e
	 */
	public static void generateDocumentoResultado(PdfWriter writerResolucion,
			Document document, Resultado resultado, String imagen,
			String parrafo1Sol, String tituloPosiciones, String parrafo22Sol,
			String imagenSol, String parrafo24Sol, String tituloTabla,
			String parrafo1Datos, String parrafo21Datos, String parrafo22Datos,
			String parrafo23Datos, String parrafo24Datos, String tituloBobinas,
			String tituloId, String tituloAnchura, String tituloDiametroext,
			String tituloPeso, String tituloDistancia, String parrafo1Rec,
			String parrafo2rec, String intdiametroExt, String intdiametroInt,
			String intanchura, String intpeso, String parrafo3rec,
			String pesobobinas, String diametroextbobinas,
			String diametrointbobinas, String anchurabobinas, String imagenRec,
			String rutaDatos, boolean mostrarGraficos)
			throws DocumentException, IOException {

		UtilPDF.addMetaData(document);

		// IMAGEN DE CABECERA
		ResultadoPDF.generateCabeceraDocumento(writerResolucion, document,
				imagen);

		// TABLA BODY
		PdfPTable table = ResultadoPDF.createTablePdf(resultado, parrafo1Sol,
				tituloPosiciones, parrafo22Sol, imagenSol, parrafo24Sol,
				tituloTabla, parrafo1Datos, parrafo21Datos, parrafo22Datos,
				parrafo23Datos, parrafo24Datos, tituloBobinas, tituloId,
				tituloAnchura, tituloDiametroext, tituloPeso, tituloDistancia,
				parrafo1Rec, parrafo2rec, intdiametroExt, intdiametroInt,
				intanchura, intpeso, parrafo3rec, pesobobinas,
				diametroextbobinas, diametrointbobinas, anchurabobinas,
				imagenRec, rutaDatos, mostrarGraficos);
		document.add(table);
	}

	/**
	 * Genera la cabecera del documento con el logo.
	 * 
	 * @param writerResolucion
	 * @param document
	 * @param imagen
	 * @throws IOException
	 *             e
	 * @throws DocumentException
	 *             e
	 * @throws Exception
	 */
	private static void generateCabeceraDocumento(PdfWriter writerResolucion,
			Document document, String imagen) throws IOException,
			DocumentException {
		Image logo = Image.getInstance(imagen);
		logo.setAbsolutePosition(130, 750);
		logo.scalePercent(60f);
		writerResolucion.getDirectContent().addImage(logo);
		UtilPDF.addParagraphEmpty(document);
	}

	private static PdfPTable getTableDatosIntroduccion(Resultado resultado,
			String parrafo1Sol, String tituloPosiciones, String parrafo22Sol,
			String imagenSol, String parrafo24Sol, String tituloTabla,
			String parrafo1Datos, String parrafo21Datos, String parrafo22Datos,
			String parrafo23Datos, String parrafo24Datos, String tituloBobinas,
			String tituloId, String tituloAnchura, String tituloDiametroext,
			String tituloPeso, String tituloDistancia, String parrafo1Rec,
			String parrafo2rec, String intdiametroExt, String intdiametroInt,
			String intanchura, String intpeso, String parrafo3rec,
			String pesobobinas, String diametroextbobinas,
			String diametrointbobinas, String anchurabobinas, String imagenRec,
			String rutaDatos, boolean mostrarGraficos) {
		PdfPTable tablaDatosIntroduccion = new PdfPTable(1);
		tablaDatosIntroduccion.getDefaultCell().setBorder(0);

		// Locale locale = LocaleContextHolder.getLocale();
		// //////////////////////////////////////////////
		// DATOS VEHICULO
		Paragraph parrafoDatosVehiculo = new Paragraph();
		Phrase frase21Datos = new Phrase(parrafo21Datos + "\n",
				ConstantesPDF.fontH2);
		parrafoDatosVehiculo.add(frase21Datos);
		Phrase frase22Datos = new Phrase(parrafo22Datos + "\n\n",
				ConstantesPDF.parrafo);
		parrafoDatosVehiculo.add(frase22Datos);

		// INCORPORACION del vehiculo
		tablaDatosIntroduccion.addCell(UtilPDF.createCellContentParagraf(
				parrafoDatosVehiculo, Element.ALIGN_LEFT, null,
				Rectangle.NO_BORDER));

		// /////////////////////////////////////////////////////

		// DATOS TIPO SUJECION
		Paragraph parrafoDatosTipoSujecion = new Paragraph();
		Phrase frase31Datos = new Phrase(parrafo23Datos + "\n",
				ConstantesPDF.fontH2);
		Phrase frase32Datos = new Phrase(parrafo24Datos + "\n\n",
				ConstantesPDF.parrafo);
		parrafoDatosTipoSujecion.add(frase31Datos);
		parrafoDatosTipoSujecion.add(frase32Datos);
		//
		tablaDatosIntroduccion.addCell(UtilPDF.createCellContentParagraf(
				parrafoDatosTipoSujecion, Element.ALIGN_LEFT, null,
				Rectangle.NO_BORDER));
		// //////////////////////////////////////////////////////

		// // //////////////////////////////////////////////
		// // BOBINAS
		// Paragraph parrafoBobinas = new Paragraph();
		// Phrase frase4Datos = new Phrase(tituloBobinas, ConstantesPDF.fontH2);
		// parrafoBobinas.add(frase4Datos);
		//
		// PdfPCell cell = new PdfPCell(UtilPDF.createCellContentParagraf(
		// parrafoBobinas, Element.ALIGN_CENTER, UtilPDF.AZUL,
		// Rectangle.NO_BORDER));
		// tablaDatosIntroduccion.addCell(cell);
		//
		// Transporte transporte = resultado.getTransporte();
		// List<Bobina> bobinas = transporte.getBobinas();
		// // TABLA BOBINAS
		// float[] ancho2 = new float[] { 40, 36, 26 };
		//
		// PdfPTable tablaBobinas = null;
		// try {
		// tablaBobinas = UtilPDF.createTablePresentacion2(3, ancho2);
		// } catch (Exception e) {
		// }
		// tablaBobinas.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
		// tituloAnchura, ConstantesPDF.parrafobold),
		// Element.ALIGN_CENTER, null, Rectangle.BOX));
		// tablaBobinas.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
		// tituloDiametroext, ConstantesPDF.parrafobold),
		// Element.ALIGN_CENTER, null, Rectangle.BOX));
		// tablaBobinas.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
		// tituloPeso, ConstantesPDF.parrafobold), Element.ALIGN_CENTER,
		// null, Rectangle.BOX));
		//
		// for (int i = 0; i < bobinas.size(); i++) {
		//
		// tablaBobinas.addCell(UtilPDF.createCellContentParagraf(
		// new Paragraph(bobinas.get(i).getAnchura().toString(),
		// ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
		// Rectangle.BOX));
		// tablaBobinas.addCell(UtilPDF.createCellContentParagraf(
		// new Paragraph(bobinas.get(i).getDiametroExt().toString(),
		// ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
		// Rectangle.BOX));
		// tablaBobinas.addCell(UtilPDF.createCellContentParagraf(
		// new Paragraph(bobinas.get(i).getPeso().toString(),
		// ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
		// Rectangle.BOX));
		// }
		// // INCORPORACION DE LA TABLA DE BOBINAS
		// tablaDatosIntroduccion.addCell(tablaBobinas);

		// ///////////////////////////////////////////

		// blanco
		PdfPCell cellblanco = UtilPDF.createCellContentParagraf(new Paragraph(
				Chunk.NEWLINE), Element.ALIGN_LEFT, null, Rectangle.NO_BORDER);
		// blanco
		tablaDatosIntroduccion.addCell(cellblanco);

		// RECOMENDACIONES
		int number = 157;
		// RECOMENDACIONES
		Paragraph parrafo1Recomen = new Paragraph();
		Phrase frase1Rec = new Phrase("\n" + parrafo1Rec + "\n",
				ConstantesPDF.parrafo);
		Phrase frase2Rec = new Phrase("\n" + parrafo2rec + "\n",
				ConstantesPDF.parrafobold);

		Phrase frase3Rec = new Phrase(intdiametroExt + " "
				+ Character.toString((char) number) + "\n",
				ConstantesPDF.parrafo);
		Phrase frase4Rec = new Phrase(intdiametroInt + " "
				+ Character.toString((char) number) + "\n",
				ConstantesPDF.parrafo);
		Phrase frase5Rec = new Phrase(intanchura + "\n", ConstantesPDF.parrafo);
		Phrase frase6Rec = new Phrase(intpeso + "\n", ConstantesPDF.parrafo);
		Phrase fraseBlanco = new Phrase("\n", ConstantesPDF.parrafo);

		parrafo1Recomen.add(frase1Rec);
		parrafo1Recomen.add(frase2Rec);
		parrafo1Recomen.add(frase3Rec);
		// parrafo1Recomen.add(frase4Rec);
		parrafo1Recomen.add(frase5Rec);
		parrafo1Recomen.add(frase6Rec);
		parrafo1Recomen.add(fraseBlanco);
		parrafo1Recomen.add(frase4Rec);

		Paragraph parrafo2Recomen = new Paragraph();
		Phrase frase7Rec = new Phrase("\n\n" + parrafo3rec + "\n",
				ConstantesPDF.parrafobold);
		Phrase frase8Rec = new Phrase("\n" + pesobobinas, ConstantesPDF.parrafo);
		Phrase frase9Rec = new Phrase("\n" + Character.toString((char) number)
				+ diametroextbobinas, ConstantesPDF.parrafo);
		/*
		 * Phrase frase10Rec = new Phrase("\n" + Character.toString((char)
		 * number) + diametrointbobinas, ConstantesPDF.parrafo);
		 */
		Phrase frase11Rec = new Phrase("\n" + anchurabobinas,
				ConstantesPDF.parrafo);

		parrafo2Recomen.add(frase7Rec);
		parrafo2Recomen.add(frase8Rec);
		parrafo2Recomen.add(frase9Rec);
		// parrafo2Recomen.add(frase10Rec);
		parrafo2Recomen.add(frase11Rec);

		// Recomendaciones parte 1
		tablaDatosIntroduccion.addCell(parrafo1Recomen);
		// Imagen recomendaciones
		Image imageRecomendacion = null;
		try {
			imageRecomendacion = Image.getInstance(imagenRec);
		} catch (Exception e) {
		}
		PdfPTable tablaRecImagen = new PdfPTable(1);
		tablaRecImagen.getDefaultCell().setBorder(0);
		float[] anchoImagen = new float[] { 3, 12, 3 };
		try {
			tablaRecImagen = UtilPDF.createTablePresentacion2(3, anchoImagen);
		} catch (Exception e) {
		}

		tablaRecImagen.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
				" ", ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
				Rectangle.NO_BORDER));
		if (mostrarGraficos) {
			imageRecomendacion.setBorder(Image.NO_BORDER);
			tablaRecImagen.addCell(imageRecomendacion);
		} else {
			tablaRecImagen.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(" ", ConstantesPDF.parrafo),
					Element.ALIGN_CENTER, null, Rectangle.NO_BORDER));
		}

		tablaRecImagen.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
				" ", ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
				Rectangle.NO_BORDER));
		tablaDatosIntroduccion.addCell(tablaRecImagen);
		// Recomendaciones parte 2
		tablaDatosIntroduccion.addCell(parrafo2Recomen);

		return tablaDatosIntroduccion;
	}

	private static PdfPTable getTableResultadoSimulacion(Resultado resultado,
			String parrafo1Sol, String tituloPosiciones, String parrafo22Sol,
			String imagenSol, String parrafo24Sol, String tituloTabla,
			String parrafo1Datos, String parrafo21Datos, String parrafo22Datos,
			String parrafo23Datos, String parrafo24Datos, String tituloBobinas,
			String tituloId, String tituloAnchura, String tituloDiametroext,
			String tituloPeso, String tituloDistancia, String parrafo1Rec,
			String parrafo2rec, String intdiametroExt, String intdiametroInt,
			String intanchura, String intpeso, String parrafo3rec,
			String pesobobinas, String diametroextbobinas,
			String diametrointbobinas, String anchurabobinas, String imagenRec,
			String rutaDatos, boolean mostrarGraficos) {

		final int NUM_COLUMNS_TABLA_RESULTADO = 1;
		final int TABLA_SIN_BORDE = 0;
		PdfPTable tablaResultadoSimulacion = new PdfPTable(
				NUM_COLUMNS_TABLA_RESULTADO);
		tablaResultadoSimulacion.getDefaultCell().setBorder(TABLA_SIN_BORDE);

		Transporte transporte = resultado.getTransporte();
		List<Bobina> bobinas = transporte.getBobinas();
		TipoDistancia tipoDistancia = resultado.getTipoDistancia();

		Locale locale = LocaleContextHolder.getLocale();

		String distancia = (locale.equals(Constantes.LOCALE_EU)) ? tipoDistancia
				.getDescEu() : tipoDistancia.getDescEs();

		final float COLUMN_POS_BOBINA_ID = 10;
		final float COLUMN_POS_BOBINA_ANCHURA = 40;
		final float COLUMN_POS_BOBINA_DIAMETRO_EXT = 30;
		final float COLUMN_POS_BOBINA_DIAMETRO_INT = 20;
		final float COLUMN_POS_BOBINA_DISTANCIA = 20;
		final int NUM_COLUMNAS_UBICACIONES = 5;
		// TABLA POSICIONES
		float[] COLUMNS_UBICACIONES = new float[] { COLUMN_POS_BOBINA_ID,
				COLUMN_POS_BOBINA_ANCHURA, COLUMN_POS_BOBINA_DIAMETRO_EXT,
				COLUMN_POS_BOBINA_DIAMETRO_INT, COLUMN_POS_BOBINA_DISTANCIA };

		PdfPTable tablaPosiciones = null;
		try {

			tablaPosiciones = UtilPDF.createTablePresentacion2(
					NUM_COLUMNAS_UBICACIONES, COLUMNS_UBICACIONES);
		} catch (Exception e) {

		}
		// UBICACIONES
		Paragraph parrafoUbicaciones = new Paragraph();
		Phrase frase21Sol = new Phrase(tituloPosiciones,
				ConstantesPDF.fontH2Tabla);
		parrafoUbicaciones.add(frase21Sol);
		PdfPCell cell = null;
		PdfPCell cellUbicaciones = new PdfPCell(
				UtilPDF.createCellContentParagraf(parrafoUbicaciones,
						Element.ALIGN_CENTER, UtilPDF.AZUL, Rectangle.NO_BORDER));
		cellUbicaciones.setColspan(NUM_COLUMNAS_UBICACIONES);
		cellUbicaciones.setBackgroundColor(UtilPDF.AZUL);
		tablaResultadoSimulacion.addCell(cellUbicaciones);

		tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
				new Paragraph(tituloId, ConstantesPDF.parrafobold),
				Element.ALIGN_CENTER, null, Rectangle.BOX));
		tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
				new Paragraph(tituloAnchura, ConstantesPDF.parrafobold),
				Element.ALIGN_CENTER, null, Rectangle.BOX));
		tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
				new Paragraph(tituloDiametroext, ConstantesPDF.parrafobold),
				Element.ALIGN_CENTER, null, Rectangle.BOX));
		tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
				new Paragraph(tituloPeso, ConstantesPDF.parrafobold),
				Element.ALIGN_CENTER, null, Rectangle.BOX));
		tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
				new Paragraph(tituloDistancia, ConstantesPDF.parrafobold),
				Element.ALIGN_CENTER, null, Rectangle.BOX));

		for (int i = 0; i < bobinas.size(); i++) {
			tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(bobinas.get(i).getPosicion()
							.getIdentificacion().toString(),
							ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
					Rectangle.BOX));
			tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(bobinas.get(i).getAnchura().toString(),
							ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
					Rectangle.BOX));

			tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(bobinas.get(i).getDiametroExt().toString(),
							ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
					Rectangle.BOX));
			tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(Utilidades.format(bobinas.get(i).getPeso(),
							Constantes.NUM_DECIMALES_PESO),
							ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
					Rectangle.BOX));
			tablaPosiciones.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(bobinas.get(i).getDistancia().toString(),
							ConstantesPDF.parrafo), Element.ALIGN_CENTER, null,
					Rectangle.BOX));
		}
		// ADD TABLA DE POSICIONES
		tablaResultadoSimulacion.addCell(tablaPosiciones);

		// DISTANCIA
		Paragraph parrafoDistancia = new Paragraph("(*)" + distancia,
				ConstantesPDF.parrafo);
		tablaResultadoSimulacion.addCell(UtilPDF
				.createCellContentParagraf(parrafoDistancia,
						Element.ALIGN_LEFT, null, Rectangle.NO_BORDER));

		// INCORPORACION DE LA IMAGEN DE LA SOLUCION
		Image imageSolucion = null;
		try {
			imageSolucion = Image.getInstance(imagenSol);
		} catch (Exception e) {
		}
		if (mostrarGraficos) {
			tablaResultadoSimulacion.addCell(imageSolucion);
		} else {
			tablaResultadoSimulacion.addCell(UtilPDF.createCellContentParagraf(
					new Paragraph(" ", ConstantesPDF.parrafo),
					Element.ALIGN_CENTER, null, Rectangle.NO_BORDER));
		}

		// TABLA ESTIBAS
		Paragraph parrafoEstibas = new Paragraph();
		Phrase frase41Sol = new Phrase(parrafo24Sol, ConstantesPDF.fontH2Tabla);
		parrafoEstibas.add(frase41Sol);

		// INCORPORACION DEL TITULO TABLA ESTIBAS
		cell = new PdfPCell(UtilPDF.createCellContentParagraf(parrafoEstibas,
				Element.ALIGN_CENTER, UtilPDF.AZUL, Rectangle.NO_BORDER));
		tablaResultadoSimulacion.addCell(cell);

		List<Estiba> estibas = resultado.getSolucion().getEstibas();

		final float COLUMN_ESTIBA_DESC = 38;
		final float COLUMN_ESTIBA_IMG = 12;
		final int NUM_COLUMNAS_ESTIBAS = 2;
		float[] COLUMNS_ESTIBAS = new float[] { COLUMN_ESTIBA_DESC,
				COLUMN_ESTIBA_IMG };
		PdfPTable tablaEstibas = null;
		try {
			tablaEstibas = UtilPDF.createTablePresentacion2(
					NUM_COLUMNAS_ESTIBAS, COLUMNS_ESTIBAS);
		} catch (Exception e) {
		}

		for (int i = 0; i < estibas.size(); i++) {
			String textoEstibas = (locale.equals(Constantes.LOCALE_EU)) ? estibas
					.get(i).getDescEu() : estibas.get(i).getDescEs();
			Image imagenEstibas = null;
			try {
				String estibaimagen = locale.equals(Constantes.LOCALE_EU) ? estibas
						.get(i).getImagenEu() : estibas.get(i).getImagenEs();

				imagenEstibas = Image.getInstance(rutaDatos + estibaimagen);
			} catch (Exception e) {
			}
			cell = UtilPDF.createCellContentParagraf(new Paragraph(
					textoEstibas, ConstantesPDF.parrafo), Element.ALIGN_CENTER,
					null, Rectangle.BOX, mostrarGraficos);
			tablaEstibas.addCell(cell);
			if (mostrarGraficos) {
				tablaEstibas.addCell(imagenEstibas);
			}
		}
		// INCORPORACION DE LA TABLA DE ESTIBAS
		tablaResultadoSimulacion.addCell(tablaEstibas);

		// blanco
		PdfPCell cellblanco = UtilPDF.createCellContentParagraf(new Paragraph(
				Chunk.NEWLINE), Element.ALIGN_LEFT, null, Rectangle.NO_BORDER);
		// blanco
		tablaResultadoSimulacion.addCell(cellblanco);

		return tablaResultadoSimulacion;
	}

	/**
	 * 
	 * Descripcion de pdf favorable
	 * 
	 * 
	 * @return
	 * @throws DocumentException
	 */

	private static PdfPTable createTablePdf(Resultado resultado,
			String parrafo1Sol, String tituloPosiciones, String parrafo22Sol,
			String imagenSol, String parrafo24Sol, String tituloTabla,
			String parrafo1Datos, String parrafo21Datos, String parrafo22Datos,
			String parrafo23Datos, String parrafo24Datos, String tituloBobinas,
			String tituloId, String tituloAnchura, String tituloDiametroext,
			String tituloPeso, String tituloDistancia, String parrafo1Rec,
			String parrafo2rec, String intdiametroExt, String intdiametroInt,
			String intanchura, String intpeso, String parrafo3rec,
			String pesobobinas, String diametroextbobinas,
			String diametrointbobinas, String anchurabobinas, String imagenRec,
			String rutaDatos, boolean mostrarGraficos) throws DocumentException {

		// DEF. TABLA PRESENTACION DATOS - · COLUMNAS
		float[] ancho = new float[] { ConstantesPDF.COLUM_IZQ,
				ConstantesPDF.COLUM_CENT, ConstantesPDF.COLUM_DRCH };
		PdfPTable table = UtilPDF.createTablePresentacion(
				ConstantesPDF.NUMBER_COLUMNS_DOC, ancho);
		// blanco
		ResultadoPDF.generateLineaVacia(table);

		table.getDefaultCell().setBorder(0);

		// COLUMNA DATOS DE INTRODUCCION
		table.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
				parrafo1Datos, ConstantesPDF.fontH1), Element.ALIGN_CENTER,
				null, Rectangle.NO_BORDER));
		// ESPACIO ENTRE COLUMNAS
		table.addCell(UtilPDF.createCellContentParagraf(new Paragraph(),
				Element.ALIGN_LEFT, null, Rectangle.NO_BORDER));

		// COLUMNA RESULTADO
		table.addCell(UtilPDF.createCellContentParagraf(new Paragraph(
				parrafo1Sol, ConstantesPDF.fontH1), Element.ALIGN_CENTER, null,
				Rectangle.NO_BORDER));

		// FILA EN BLANCO
		ResultadoPDF.generateLineaVacia(table);

		// TABLA DE DATOS DE INTRODUCCION
		PdfPTable tablaDatosIntroduccion = ResultadoPDF
				.getTableDatosIntroduccion(resultado, parrafo1Sol,
						tituloPosiciones, parrafo22Sol, imagenSol,
						parrafo24Sol, tituloTabla, parrafo1Datos,
						parrafo21Datos, parrafo22Datos, parrafo23Datos,
						parrafo24Datos, tituloBobinas, tituloId, tituloAnchura,
						tituloDiametroext, tituloPeso, tituloDistancia,
						parrafo1Rec, parrafo2rec, intdiametroExt,
						intdiametroInt, intanchura, intpeso, parrafo3rec,
						pesobobinas, diametroextbobinas, diametrointbobinas,
						anchurabobinas, imagenRec, rutaDatos, mostrarGraficos);

		// TABLA DE RESULTADO DE LA SIMULACION
		PdfPTable tablaResultadoSimulacion = ResultadoPDF
				.getTableResultadoSimulacion(resultado, parrafo1Sol,
						tituloPosiciones, parrafo22Sol, imagenSol,
						parrafo24Sol, tituloTabla, parrafo1Datos,
						parrafo21Datos, parrafo22Datos, parrafo23Datos,
						parrafo24Datos, tituloBobinas, tituloId, tituloAnchura,
						tituloDiametroext, tituloPeso, tituloDistancia,
						parrafo1Rec, parrafo2rec, intdiametroExt,
						intdiametroInt, intanchura, intpeso, parrafo3rec,
						pesobobinas, diametroextbobinas, diametrointbobinas,
						anchurabobinas, imagenRec, rutaDatos, mostrarGraficos);

		// TABLA GENERAL
		table.addCell(tablaDatosIntroduccion);

		table.addCell(UtilPDF.createCellContentParagraf(new Paragraph(),
				Element.ALIGN_LEFT, null, Rectangle.NO_BORDER));

		table.addCell(tablaResultadoSimulacion);

		return table;
	}

	/**
	 * Creamos un espacio entre lineas
	 * 
	 * @param table
	 * @return
	 */
	public static PdfPTable generateLineaVacia(PdfPTable table) {
		// blanco
		PdfPCell cellblanco = UtilPDF.createCellContentParagraf(new Paragraph(
				Chunk.NEWLINE), Element.ALIGN_LEFT, null, Rectangle.NO_BORDER);
		// blanco
		table.addCell(cellblanco);
		table.addCell(cellblanco);
		table.addCell(cellblanco);
		return table;
	}

}
